Vue.component('frentes_obra',{
    data: function () {
        return {
          files: [],
          datos_frentes: JSON.parse(store.state.frentes_obra.frentes),
          isImageModalActive: false
        }
    },
    template: /*html*/`
   <div>
   <div class="box is-mobile has-background-light p-1 m-1">
                    <p class="title is-4 text-white bg-success p-2 m-2"  style="width:100%">Administrar frentes de obra</p>
                    <b-field class="field column is-full-mobile p-1 m-1" label="Fecha de inicio">
                    <b-datepicker v-model="fecha_inicial"
                        placeholder="Seleccionar fecha..."
                        icon="calendar-today"
                        trap-focus>
                    </b-datepicker>
                    </b-field>  

 
                  <b-field class="file m-2 p-2">
                  <b-upload v-model="files">
                    <a class="button is-success">
                      <b-icon icon="upload"></b-icon>
                      <span>Seleccionar archivo con frentes de obra</span>
                    </a>
                  </b-upload>

                </b-field>
     




                    <div class="columns is-gapless m-0 p-0" v-for="(value, key) in datos_frentes">
                    <div class="column">
                      <div class="columns border border-dark rounded is-gapless  p-1">

                  
                      <b-checkbox v-model="datos_frentes[key].activo"  class="m-1 p-1" 
                      @click.native="elijo_frente(key)"
                      type="is-success">
                      </b-checkbox>


                    <div class="column bg-white rounded m-1 p-1">Fecha: {{value.fecha.substr(0,10)}}</div>
                    <b-button class="m-1 p-1 is-mobile" style="width:40px" @click.native="elimino_frente(key)" type="is-danger" size="is-medium" icon-right="trash-can"></b-button>

                          
                      </div>
                    </div>
                  </div>
        <footer> 
                <div class="columns is-gapless is-multiline is-mobile m-1 p-1">
                    <div class="column is-full-mobile  m-1 p-1">
                    <b-button  @click="volver()" type="is-success" rounded  expanded  icon-left="arrow-left-circle">
                    Volver
                    </b-button>
                    </div>
                </div>
        </footer>
</div>
 
 </div>  		
    `,
    computed:{
      fecha_inicial:{
        get:  function () {
          var fecha = new Date();
          store.state.frentes_obra.fecha = app.obtengo_fecha(fecha);
        return fecha;
         },
        set:  function (valor) {
          store.state.frentes_obra.fecha = app.obtengo_fecha(valor);
          },
        }
    },
    watch:{
      files: function(o, n) {
        var extension = o.name.substr(o.name.length - 3);
        var frentes = '';
        if (extension.toUpperCase() !== 'CSV' && extension.toUpperCase() !== 'TXT')
        {
          this.$buefy.toast.open('El archivo seleccionado debe ser csv o txt');
        }
        else
        {
        var reader = new FileReader();
        reader.onload = e => {
          var contenido = e.target.result;
          var renglones = contenido.split('\n');
          var cant_frentes = 0;
            for(i=0;i<renglones.length;i++){
              var renglon = renglones[i];
              var array_contenido_coma = renglon.split(",");
              var array_contenido_puntoycoma = renglon.split(";");
              if (array_contenido_coma.length > array_contenido_puntoycoma.length)
              {
                var array_contenido = array_contenido_coma;
              }else
              {
                var array_contenido = array_contenido_puntoycoma;
              }  
              var prog1 = Number(array_contenido[0]);
              var prog2 = Number(array_contenido[1]);
              if (prog1 >= 0 && prog1 < prog2 && prog2 < 300000)
              {
                cant_frentes++;
                if (frentes == '')
                {
                frentes = frentes + array_contenido[0].trim() + ';' + array_contenido[1].trim();
                }
                else
                {
                frentes = frentes + ';' + array_contenido[0].trim() + ';' + array_contenido[1].trim(); 
                }
              }          
            }
            if (cant_frentes > 0){
            this.$buefy.dialog.confirm({
              title: 'Carga de frentes de obra',
              message: 'Cargar los datos de ' + cant_frentes + ' frentes de obra en fecha ' + store.state.frentes_obra.fecha.substr(0,10),
              confirmText: 'Confirma carga?',
              type: 'is-danger',
              hasIcon: true,
              onConfirm: () => {
                var elemento = {fecha: store.state.frentes_obra.fecha,frentes: frentes};
                this.datos_frentes.push(elemento);
                store.state.frentes_obra.frentes = JSON.stringify(this.datos_frentes);
                var sql = "INSERT INTO frentes_obra(FECHA,FRENTES)VALUES('" + store.state.frentes_obra.fecha + "','" + frentes + "')";
                //console.log(sql);
                var fd = new FormData();
                fd.append("sql",sql);
                    var getUrl = window.location;
                    var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
                    var phpfile = baseUrl + '/php/frentes_obra_modificar.php';
                    var xhr = new XMLHttpRequest();	
                    xhr.open('POST',phpfile,true);
                    xhr.onload = function() {
                    var data = JSON.parse(this.response);
                    caches.open('ADAPTA_CACHE-V1').then(cache => {
                    cache.match('/sincronizacion/frentes_obra.json').then(item => {
                    cache.put('/sincronizacion/frentes_obra.json', new Response(JSON.stringify(data)));
                      })
                    })
                    };
                    xhr.send(fd);
              }  
              }) 
             }
             else{
              this.$buefy.toast.open('El archivo no tiene el formato correcto');
             }
            }
            reader.readAsText(o);
          } 
      }
      
    },
    methods:{
      volver(){
        store.state.layout_visible = 'layout_menu_principal';  
      },
      elijo_frente(e){
        for (i=0;i<this.datos_frentes.length;i++){
          this.datos_frentes[i].activo = 0;
        }
        this.datos_frentes[e].activo = 1;
        store.state.frentes_obra.frentes = JSON.stringify(this.datos_frentes);
      },
      elimino_frente(e){
      this.$buefy.dialog.confirm({
          title: 'Eliminar frentes de obra',
          message: 'Eliminar los datos de los frentes de obra seleccionados',
          confirmText: 'Confirma eliminar?',
          type: 'is-danger',
          hasIcon: true,
          onConfirm: () => {
            var frente_a_eliminar = this.datos_frentes[e].frentes;
            this.datos_frentes.splice(e,1);
            store.state.frentes_obra.frentes = JSON.stringify(this.datos_frentes);
            var sql = "DELETE FROM frentes_obra WHERE FRENTES = '" + frente_a_eliminar + "'";
           // console.log(sql);
            var fd = new FormData();
            fd.append("sql",sql);
                var getUrl = window.location;
                var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
                var phpfile = baseUrl + '/php/frentes_obra_modificar.php';
                var xhr = new XMLHttpRequest();	
                xhr.open('POST',phpfile,true);
                xhr.onload = function() {
                var data = JSON.parse(this.response);
                caches.open('ADAPTA_CACHE-V1').then(cache => {
                cache.match('/sincronizacion/frentes_obra.json').then(item => {
                cache.put('/sincronizacion/frentes_obra.json', new Response(JSON.stringify(data)));
                  })
                })
                };
                xhr.send(fd);
          }  
          }) 
    }
  }
            
 })