Vue.component('ver_registro',{
    data: function () {
        return {
          id_ref: store.state.datos_registro.id_ref,
          id: store.state.datos_registro.id,
          tipo: store.state.datos_registro.tipo,
          punto: store.state.datos_registro.punto,
          progresiva: store.state.datos_registro.progresiva,
          obrador: store.state.datos_registro.obrador,
          frecuencia: store.state.datos_registro.frecuencia,
          tipo_obra: store.state.datos_registro.tipo_obra,
          cant_insp: store.state.datos_registro.cant_insp,
          foto: store.state.datos_registro.foto,
          tramo: store.state.datos_registro.tramo,
          zona_urbana: store.state.datos_registro.zona_urbana,
          disponible: store.state.datos_registro.disponible,
          fecha_ini: store.state.datos_registro.fecha_ini,
          ifc: store.state.datos_ruido_standard.ifc,
          ifclb3: store.state.datos_ruido_standard.ifclb3,
          mvotma: store.state.datos_ruido_standard.mvotma,
          lbx: store.state.datos_ruido_standard.lbx,
          hayconexion: store.state.hayconexion,
          ver_datos: true,
          isImageModalActive: false,
          isStandardModalActive: false
        }
    },
    template: /*html*/`
   <div>

   <div class="box is-mobile has-background-light p-1 m-1">

   <div class="level bg-success" style="width:100%">  
   <p class="level-left title is-4 text-white bg-success p-2 m-2" >Registro {{id_ref}}</p>
   <b-button v-if="tipo == 'Ruido'" @click="cambio_standard_ruido()" class="level-rigth p-2 m-2 is-dark" style="width:180px" type="is-success" rounded  icon-left="cloud-upload">
   Estandar diurno
   </b-button>
   </div>



          <div class="column mt-0 pt-0">
                  <b-button style="height:55px" @click="ver_datos = !ver_datos" expanded type="is-success" :icon-right="ver_datos ? 'upload' : 'download'" >
                  <strong>{{ver_datos ? 'Cerrar datos de registro' : 'Ver datos de registro'}}</strong>
                  </b-button>
                  <ul class="list-group" v-if="ver_datos">
                        <li class="list-group-item"><strong><span style="color: #588585">Tipo:</span></strong> {{tipo}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Progresiva:</span></strong> {{progresiva}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Punto:</span></strong> {{punto}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Sitio:</span></strong> {{obrador}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Frecuencia:</span></strong> {{frecuencia}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Tipo de obra:</span></strong> {{tipo_obra}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Tramo:</span></strong> {{tramo}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Zona poblada:</span></strong> {{zona_urbana}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Disponible:</span></strong> {{disponible}}</li>
                        <li class="list-group-item"><strong><span style="color: #588585">Fecha inicial:</span></strong> {{fecha}}</li>


                  </ul>
      
          </div>

          <b-modal :active.sync="isImageModalActive">
          <p class="image is-5by3">
          <img class="has-ratio" v-if="$store.state.datos_registro.foto !== '' && hayconexion == true" v-bind:src=this.foto alt="Foto de sitio">
          </p>
          </b-modal>


<footer>
<div class="columns is-gapless is-multiline is-mobile m-1 p-1">
  <div class="column is-full-mobile  m-1 p-1">
  <b-button  @click="ver_foto()" type="is-success" rounded  expanded icon-left="camera-image" >
  Ver Foto
  </b-button>
  </div>

  <div class="column is-full-mobile m-1 p-1">
  <b-button  @click="modificar_registro()" type="is-success" rounded  expanded icon-left="pen-plus" >
  Modificar Registro
  </b-button>
  </div>


  <div class="column is-full-mobile m-1 p-1">
  <b-button  @click="ver_historico()" type="is-success" rounded  expanded icon-left="dna" >
  Ver historico
  </b-button>
  </div>  
  <div class="column is-full-mobile m-1 p-1">
  <b-button  @click="inspeccionar()" type="is-success" rounded  expanded icon-left="eye-plus" >
  Nueva inspección
  </b-button>
  </div>  
  <div class="column is-full-mobile m-1 p-1">
  <b-button  @click="volver()" type="is-success" rounded  expanded icon-left="arrow-left-circle" >
  Volver
  </b-button>
  </div>  
  </div>
</footer>

</div>  




<b-modal :active.sync="isStandardModalActive"
  has-modal-card
  trap-focus
  :destroy-on-hide="false"
  aria-role="dialog"
  aria-modal>
  <form action="">
  <div class="modal-card" style="width: auto">
      <header class="modal-card-head">
          <p class="modal-card-title">Datos de standard diurno en registro</p>
      </header>
      <section class="modal-card-body">
      <div class="columns is-gapless is-multiline is-mobile m-1 p-1">     

      <b-field class="field column is-full-mobile p-1 m-1" label="IFC:" type="is-success" style="width:80px">
       <b-input placeholder="IFC:"  @input.native="actualizo_IFC"  v-model="ifc"></b-input>
      </b-field>
   
      <b-field class="field column is-full-mobile p-1 m-1" label="IFCLB+3:" type="is-success" style="width:80px">
       <b-input placeholder="IFCLB+3:"   @input.native="actualizo_IFCLB3" v-model="ifclb3"></b-input>
      </b-field>
  
      <b-field class="field column is-full-mobile p-1 m-1" label="MVOTMA:" type="is-success" style="width:80px">
      <b-input placeholder="MVOTMA:"  @input.native="actualizo_mvotma"  v-model="mvotma"></b-input>
     </b-field>
       
      <b-field class="field column is-full-mobile p-1 m-1" label="LB+X:" type="is-success" style="width:80px">
       <b-input placeholder="LB+X:"  @input.native="actualizo_lbx" v-model="lbx"></b-input>
      </b-field>
   
    </div>


      </section>
      <footer class="modal-card-foot">
          <button class="button" type="button" @click="isStandardModalActive=false">Cerrar</button>
          <b-button  @click="guardo_ruido_standard()" type="is-danger" icon-left="cloud-upload">
            Guardar
          </b-button>
      </footer>
  </div>
</form>
</b-modal>




</div>  		
    `,
    computed:{
      fecha:{
        get:  function () {
        return store.state.datos_registro.fecha_ini.substring(0,11);
         },
        set:  function (valor) {
          store.state.datos_registro.fecha_ini =  valor;
          },
        }
      },   
    methods:{
      actualizo_IFC(e){
        store.state.datos_ruido_standard.ifc = e.target.value;
      },
      actualizo_IFCLB3(e){
        store.state.datos_ruido_standard.ifclb3 = e.target.value;
      },
      actualizo_mvotma(e){
        store.state.datos_ruido_standard.mvotma = e.target.value;
      },
      actualizo_lbx(e){
        store.state.datos_ruido_standard.lbx = e.target.value;
      },
      cambio_standard_ruido(){
        caches.open('ADAPTA_CACHE-V1').then(cache => {
          cache.match('/sincronizacion/ruido_standard.json').then(item => { 
            item.json().then(buffer => {
                for(i=0;i<buffer.length;i++){
                  if (buffer[i].id_registro === store.state.datos_registro.id)
                  {
                    store.state.datos_ruido_standard.id_registro = store.state.datos_registro.id;
                    store.state.datos_ruido_standard.ifc = buffer[i].ifc;
                    store.state.datos_ruido_standard.ifclb3 = buffer[i].ifclb3;
                    store.state.datos_ruido_standard.mvotma = buffer[i].mvotma;
                    store.state.datos_ruido_standard.lbx = buffer[i].lbx;
                    this.ifc = store.state.datos_ruido_standard.ifc;
                    this.ifclb3 = store.state.datos_ruido_standard.ifclb3;
                    this.mvotma = store.state.datos_ruido_standard.mvotma;
                    this.lbx = store.state.datos_ruido_standard.lbx;
                  }
                  if(i == buffer.length -1){
                    this.isStandardModalActive = true;
                    }
                }
              })
            }) 
          })
      },
      volver(){
        store.state.layout_visible = 'layout_relevamientos';
      },
      modificar_registro(){
        store.state.layout_visible = 'editar_registro';
      },
      ver_foto(){
        if (store.state.datos_registro.foto == ''){
          this.$buefy.toast.open('No existe fotografia')
        }else
        {
          app.chequeo_conexion();
          if (store.state.hayconexion == true){
        this.isImageModalActive = true;
          }else{
            this.$buefy.toast.open('No se pueden ver fotos sin conexión')
          }
        }
      },
      ver_historico(e){//_______________________________________________________________________________________________
        if (store.state.datos_registro.tipo = 'Ruido'){
          store.state.lista_historicos = [];
            var promesa = new Promise( function(resolve, reject){    
                var inspecciones_filtradas = [];
                caches.open('ADAPTA_CACHE-V1').then(cache => {
                   cache.match('/sincronizacion/ruido_inspecciones.json').then(item => {
                      if (typeof item !== 'undefined'){
                          item.json().then(buffer => {
                              for(i=0;i<buffer.length;i++){
                                  if (buffer[i].id !== "FALSO"){
                                      var idreg = buffer[i].id_registro;
                                      if(idreg === store.state.datos_registro.id){
                                          store.state.lista_historicos.push(buffer[i]);
                                      }
                                  }   
                                  if (i == buffer.length - 1){
                                      resolve("ok");
                                  }
                              }        
                          })
                      }
                      })
  
                  })
              })
              promesa.then(result => {
                store.state.layout_visible = 'historico_inspecciones';
              })
            }
         
      },
      guardo_ruido_standard(){   
                //Genero sentencia sql completa/////////////////////////////////////////////////////////////////////////////////////////  
                    var sql1 = "UPDATE ruido_standard SET IFC = '"  + store.state.datos_ruido_standard.ifc;
                    var sql2 = "',IFCLB3 = '" + store.state.datos_ruido_standard.ifclb3 + "', MVOTMA= '" + store.state.datos_ruido_standard.mvotma;
                    var sql3 = "',LBX = '" + store.state.datos_ruido_standard.lbx + "' WHERE ID_REGISTRO = " + store.state.datos_registro.id;   
                    sql = sql1 + sql2 + sql3 ;
                    //console.log(sql);
                    app.chequeo_conexion();
                    if (store.state.hayconexion == true) { // si hay conexion........................................................................
                      //consulto base de datos
                      var fd = new FormData();
                      fd.append("sql",sql);
                          var getUrl = window.location;
                          var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
                          var phpfile = baseUrl + '/php/ruido_standard_actualizar.php';
                          var xhr = new XMLHttpRequest();	
                          xhr.open('POST',phpfile,true);
                          xhr.onload = function() {
                          var data = JSON.parse(this.response);
                            caches.open('ADAPTA_CACHE-V1').then(cache => {
                              cache.match('/sincronizacion/ruido_standard.json').then(item => {
                              cache.put('/sincronizacion/ruido_standard.json', new Response(JSON.stringify(data)));

                              });
                            });
                          };
                          xhr.send(fd);
                          this.isStandardModalActive = false;
                        }//fin si hay conexion........................................................................
                        else		
                        {
                         agrego_registros_a_sincronizar(sql,'');
            
            
            /////////////////////////////////////////////////////////////////////////////////////////////
            var registro_a_actualizar = {
              "id_registro": store.state.datos_registro.id,
              "ifc": store.state.datos_ruido_standard.ifc,
              "ifclb3": store.state.datos_ruido_standard.ifclb3,
              "mvotma": store.state.datos_ruido_standard.mvotma,
              "lbx": store.state.datos_ruido_standard.lbx
              };
            caches.open('ADAPTA_CACHE-V1').then(cache => {
              cache.match('/sincronizacion/ruido_standard.json').then(item => { 
                item.json().then(buffer => {
                    var data = [];
                    for(i=0;i<buffer.length;i++){
                      if (buffer[i].id_registro === store.state.datos_registro.id)
                      {
                        data.push(registro_a_actualizar);
                      }else
                      {
                      data.push(buffer[i]);
                      }
                    }
                    cache.put('/sincronizacion/ruido_standard.json', new Response(JSON.stringify(data)));
                    this.isStandardModalActive = false;
                  })
                }) 
                .catch(function() {
                     console.log("encontro el cache de ruido standard vacio");
                     cache.put('/sincronizacion/ruido_standard.json', new Response(JSON.stringify(registro_a_actualizar)));
                     this.isStandardModalActive = false;
                  })
                });  
                }


        },
      inspeccionar(){//_______________________________________________________________________________________________


        if (store.state.datos_registro.tipo = 'Ruido'){
            app.valores_defecto_ruido();
              //Genero sentencia sql completa/////////////////////////////////////////////////////////////////////////////////////////  
                  var usuario = store.state.datos_login.usuario;
                  var sql = "";
                  var sqlcache = "";
                  var sql1 = "INSERT INTO ruido_inspecciones(ID,ID_REGISTRO,NRO_SONOMETRO,CALIBRACION,FECHA,HORA_INI,HORA_FIN,MET_ESTADO,MET_TEMPERATURA,MET_HUMEDAD,MET_VIENTO_VELOCIDAD, MET_VIENTO_DIR,FRENTE_OBRA,FOTOS,AUDIOS,OBSERVACIONES,USUARIO,ACTIVO,EVENTOS,LAEQ,LAMX,LAMIN,LA10,LA50,LA90 )VALUES(";
                  var sql2 =  store.state.datos_ruido.id +"," + store.state.datos_ruido.id_registro + "," + store.state.datos_ruido.nro_sonometro + ",'" + store.state.datos_ruido.calibracion + "','";
                  var sql3 = store.state.datos_ruido.fecha + "','" + store.state.datos_ruido.hora_ini + "','" + store.state.datos_ruido.hora_fin + "','";
                  var sql4 = store.state.datos_ruido.met_estado + "'," + store.state.datos_ruido.met_temperatura + "," + store.state.datos_ruido.met_humedad + ",";
                  var sql5 = store.state.datos_ruido.met_viento_velocidad + ",'" + store.state.datos_ruido.met_viento_dir + "','" + store.state.datos_ruido.frente_obra + "','" + store.state.datos_ruido.fotos + "','";
                  var sql6 = store.state.datos_ruido.audios + "','" + store.state.datos_ruido.observaciones + "','" + usuario + "',1,'";
                  var sql7 = store.state.datos_ruido.eventos + "'," + store.state.datos_ruido.laeq + "," + store.state.datos_ruido.lamx + "," ;
                  var sql8 = store.state.datos_ruido.lamin + "," + store.state.datos_ruido.la10 + "," + store.state.datos_ruido.la50 + "," + store.state.datos_ruido.la90 + ")";

                      sql = sql1 + sql2 + sql3 + sql4 + sql5 + sql6 + sql7 + sql8;
                     // console.log(sql);
                     app.chequeo_conexion();
                  if (store.state.hayconexion == true) { // si hay conexion........................................................................
                    //consulto base de datos
                    var fd = new FormData();
                    fd.append("sql",sql);
                    fd.append("fotos",'');
                    fd.append("archivosfotos",'');
                        var getUrl = window.location;
                        var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
                        var phpfile = baseUrl + '/php/ruido_inspecciones_agregar.php';
                        var xhr = new XMLHttpRequest();	
                        xhr.open('POST',phpfile,true);
                        xhr.onload = function() {
                       //  console.log(this.response);
                        var data = JSON.parse(this.response);
                          caches.open('ADAPTA_CACHE-V1').then(cache => {
                            cache.match('/sincronizacion/ruido_inspecciones.json').then(item => {
                            cache.put('/sincronizacion/ruido_inspecciones.json', new Response(JSON.stringify(data)));
                            store.state.layout_visible = 'principal_ruido';
                          });
                        });
                        };
                        xhr.send(fd);
                      }//fin si hay conexion........................................................................
                      else		
                      {
                      agrego_registros_a_sincronizar(sql,'');
          
          /////////////////////////////////////////////////////////////////////////////////////////////
          var registro_nuevo = {
            "id_ref": store.state.datos_ruido.id_ref,
            "id": store.state.datos_ruido.id,
            "id_registro": store.state.datos_ruido.id_registro,
            "nro_sonometro": store.state.datos_ruido.nro_sonometro,
            "calibracion": store.state.datos_ruido.calibracion,
            "fecha": store.state.datos_ruido.fecha,
            "hora_ini": store.state.datos_ruido.hora_ini,
            "hora_fin": store.state.datos_ruido.hora_fin,
            "met_estado": store.state.datos_ruido.met_estado,
            "met_temperatura": store.state.datos_ruido.met_temperatura,
            "met_humedad": store.state.datos_ruido.met_humedad,
            "met_viento_velocidad": store.state.datos_ruido.met_viento_velocidad,
            "met_viento_dir": store.state.datos_ruido.met_viento_dir,
            "fotos": store.state.datos_ruido.fotos,
            "audios": store.state.datos_ruido.audios,
            "observaciones": store.state.datos_ruido.observaciones,
            "usuario": store.state.datos_login.usuario,
            "activo": store.state.datos_ruido.activo,
            "eventos": store.state.datos_ruido.eventos,
            "laeq": store.state.datos_ruido.laeq,
            "lamx": store.state.datos_ruido.lamx,
            "lamin": store.state.datos_ruido.lamin,
            "la10": store.state.datos_ruido.la10,
            "la50": store.state.datos_ruido.la50,
            "la90": store.state.datos_ruido.la90
          };
          caches.open('ADAPTA_CACHE-V1').then(cache => {
            cache.match('/sincronizacion/ruido_inspecciones.json').then(item => { 
              item.json().then(buffer => {
                  var data = [];
                  for(i=0;i<buffer.length;i++){
                    data.push(buffer[i]);
                  }
                  data.push(registro_nuevo);
                  cache.put('/sincronizacion/ruido_inspecciones.json', new Response(JSON.stringify(data)));
                  store.state.layout_visible = 'principal_ruido';
                })
              }) 
              .catch(function() {
                   console.log("encontro el cache de inspecciones de ruido vacio");
                   cache.put('/sincronizacion/ruido_inspecciones.json', new Response(JSON.stringify(registro_nuevo)));
                   store.state.layout_visible = 'principal_ruido';
                })
              });  
              }
      }//fin de condicional si es tipo Ruido
    }

    }
            
 })