var CACHE_NAME = 'ADAPTA_CACHE-V1';
var urlsToCache = [
  //PRINCIPALES
  '/',
  'manifest.json',
  'app.js',
  'sw.js',
  'index.html',
  'mapa.js',
  'sincronizacion.js',
  //REFERENCIAS DE BIBLIOTECAS
 
  'referencias/bootstrap/css/bootstrap-grid.css',
  'referencias/bootstrap/css/bootstrap-grid.css.map',
  'referencias/bootstrap/css/bootstrap-grid.min.css',
  'referencias/bootstrap/css/bootstrap-grid.min.css.map',
  'referencias/bootstrap/css/bootstrap-reboot.css',
  'referencias/bootstrap/css/bootstrap-reboot.css.map',
  'referencias/bootstrap/css/bootstrap-reboot.min.css',
  'referencias/bootstrap/css/bootstrap-reboot.min.css.map',
  'referencias/bootstrap/css/bootstrap.css',
  'referencias/bootstrap/css/bootstrap.css.map',
  'referencias/bootstrap/css/bootstrap.min.css',
  'referencias/bootstrap/css/bootstrap.min.css.map',
  'referencias/bootstrap/js/bootstrap.bundle.js',
  'referencias/bootstrap/js/bootstrap.bundle.js.map',
  'referencias/bootstrap/js/bootstrap.bundle.min.js',
  'referencias/bootstrap/js/bootstrap.bundle.min.js.map',
  'referencias/bootstrap/js/bootstrap.js',
  'referencias/bootstrap/js/bootstrap.js.map',
  'referencias/bootstrap/js/bootstrap.min.js',
  'referencias/bootstrap/js/bootstrap.min.js.map',
  'referencias/chart/Chart.bundle.js',
  'referencias/chart/Chart.bundle.min.js',
  'referencias/chart/Chart.js',
  'referencias/chart/Chart.min.js',
  'referencias/datatables/dataTables.bootstrap4.css',
  'referencias/datatables/dataTables.bootstrap4.js',
  'referencias/datatables/dataTables.bootstrap4.min.css',
  'referencias/datatables/dataTables.bootstrap4.min.js',
  'referencias/datatables/jquery.dataTables.js',
  'referencias/datatables/jquery.dataTables.min.js',
  'referencias/jquery/jquery-3.4.1.min.js',
  'referencias/popper/popper.min.js',
  'referencias/popper/popper.min.js.map',
  'referencias/vue/vue.js',
  'referencias/vue/vue.min.js',
  'referencias/vuex/vuex.js',
  'referencias/buefy/css/materialdesignicons.css',
  'referencias/buefy/css/materialdesignicons.css.map',
  'referencias/buefy/css/materialdesignicons.min.css',
  'referencias/buefy/css/materialdesignicons.min.css.map',
  'referencias/buefy/dist/buefy.min.css',
  'referencias/buefy/dist/materialdesignicons.min.css',
  'referencias/buefy/fonts/materialdesignicons-webfont.eot',
  'referencias/buefy/fonts/materialdesignicons-webfont.ttf',
  'referencias/buefy/fonts/materialdesignicons-webfont.woff',
  'referencias/buefy/fonts/materialdesignicons-webfont.woff2',
  'referencias/excel/FileSaver.js',
  'referencias/excel/jszip.js',
  'referencias/excel/myexcel.js',


  'referencias/turf/turf.min.js',  
  'referencias/fontawesome-free/webfonts/fa-solid-900.woff2',    
  'referencias/fontawesome-free/webfonts/fa-solid-900.woff',    
  'referencias/fontawesome-free/webfonts/fa-solid-900.ttf',
    
  //LOGOS
  'archivos/logos/icon-72x72.png',
  'archivos/logos/icon-96x96.png',
  'archivos/logos/icon-128x128.png',
  'archivos/logos/icon-144x144.png',
  'archivos/logos/icon-152x152.png',
  'archivos/logos/icon-192x192.png',
  'archivos/logos/icon-384x384.png',
  'archivos/logos/icon-512x512.png',

  //ICONOS
  'archivos/iconos/volume-up.png',
  'archivos/iconos/volume-up1.png',
  'archivos/iconos/volume-up2.png',
  'archivos/iconos/volume-up3.png',
  'archivos/iconos/volume-up4.png',
  'archivos/iconos/volume-up5.png',
  'archivos/iconos/volume-up6.png',
  'archivos/iconos/sinfoto.jpg',
    //COMPONENTES
  'componentes/login/login.js',
  'componentes/menu_principal/menu_principal.js',
  'componentes/relevamientos/relevamientos.js',
  'componentes/relevamientos/registros/nuevo_registro.js',
  'componentes/relevamientos/registros/ver_registro.js',
  'componentes/relevamientos/registros/editar_registro.js',
  'componentes/relevamientos/ruido/ruido.js',
  'componentes/relevamientos/historico/historico_inspecciones.js', 
  'componentes/administracion/administracion.js',
  'componentes/administracion/ruido/administracion_ruido.js',
  'componentes/administracion/ruido/standard_ruido.js',
  'componentes/administracion/frentes_obra/frentes_obra.js',

  //GEOJSON
    'archivos/geo/Eje_Via_Linea20.geojson',
    'archivos/geo/Eje_Via_Progresivas20.geojson',  
    'archivos/geo/Eje_Via_Progresivas100.geojson',  
    'archivos/geo/Eje_Via_Progresivas1000.geojson',  
    'archivos/geo/UY_Caminos_Faja1k.geojson',
    'archivos/geo/UY_Hidro_Faja1k.geojson',
    'archivos/geo/Edu.geojson',
    'archivos/geo/Salud.geojson',
    'archivos/geo/tile.png',
    'sincronizacion/usuarios.json',
  //LEAFLET
  'referencias/leaflet/leaflet-src.esm.js',
  'referencias/leaflet/leaflet-src.esm.js.map',
  'referencias/leaflet/leaflet-src.js',
  'referencias/leaflet/leaflet-src.js.map',
  'referencias/leaflet/leaflet.css',
  'referencias/leaflet/leaflet.js',
  'referencias/leaflet/leaflet.js.map',
  'referencias/leaflet/images/layers-2x.png',
  'referencias/leaflet/images/layers.png',
  'referencias/leaflet/images/marker-icon-2x.png',
  'referencias/leaflet/images/marker-icon.png',
  'referencias/leaflet/images/marker-shadow.png',
  'referencias/leaflet/dl_estilos/dl_estilos_leaflet.css',
  'referencias/leaflet/leaflet-bing-layer.js'
];

self.addEventListener('install', function(event) {
  console.log('Se ejecuto el evento install');  
  // Perform install steps
event.waitUntil(
    caches.open(CACHE_NAME)
      .then(function(cache) {
        console.log('Se ejecuto el evento install');
        return cache.addAll(urlsToCache);
      })
  );
});

self.addEventListener('activate', function(event) {
  console.log('Se activo una nueva versión del service worker');
  return self.clients.claim();
});


self.addEventListener('fetch', function(event) {
  event.respondWith(
    fetch(event.request).catch(function() {
          return caches.match(event.request).catch(function(){
            //console.log(event.request);
            return(event.request);
          });
    }) 
    )
});
