function foto_a_800(item){
return new Promise(function(resolve, reject) {
    //define the width to resize e.g 600px
     var resize_width = 800;//without px
    //create a FileReadr
    var reader = new FileReader();
    //image turned to base64-encoded Data URI.
    reader.readAsDataURL(item);
    reader.name = item.name;//get the image's name
    reader.size = item.size; //get the image's size
    reader.onload = function(event) {
      var img = new Image();//create a image
      img.src = event.target.result;//result is base64-encoded Data URI
      img.name = event.target.name;//set name (optional)
      img.size = event.target.size;//set size (optional)

      img.onload = function(el) {
        var elem = document.createElement('canvas');//create a canvas

        //scale the image to 600 (width) and keep aspect ratio
        var scaleFactor = resize_width / el.target.width;
        elem.width = resize_width;
        elem.height = el.target.height * scaleFactor;
  
        //draw in canvas
        var ctx = elem.getContext('2d');
        ctx.drawImage(el.target, 0, 0, elem.width, elem.height);
  
        //get the base64-encoded Data URI from the resize image
        var srcEncoded = ctx.canvas.toDataURL(el.target, 'image/jpeg', 0);
        ctx.canvas.toBlob(function(blob) 
        {
        resolve(blob);
        },'image/jpeg')
      }
    }
      })
  }