const store = new Vuex.Store({
  	state: {
		hayconexion: true,
		control_cambios: false,
		centro_gps: {latitud: -34.1, longitud: -56.21, zoom: 14},
		centro_mapa: {latitud: -34.1, longitud: -56.21, zoom: 14},
		layout_visible: 'layout_login',
		dl_popup_estado: { popup_visible: false, popup_mensaje: ['']},
		popup_nuevo_registro: {visible: false, tipo: ''},
		datos_login: { usuario: 'daniel' , password: 'daniel', email: '', permisos: '', fecha: '', celular: '', empresa: '',mensaje: ''},
		datos_registro: {id_ref: 0, id: 0 , tipo: '', punto: '', progresiva: 0, obrador: '', ubicacion: '', cant_insp: 0, activo: 1, foto: '', frecuencia: 'Mensual', tipo_obra: "Obrador", archivofoto:[], tmp_foto: '',fecha_ini:'2020-01-01',zona_urbana:'No',tramo:0},
		lista_registros: {lista: []},
		lista_historicos: [],
		datos_ruido_standard: {id_registro: 0, ifc: '', ifclb3: '', mvotma: '', lbx:''},
		datos_ruido: {id_ref: 0,id:0,id_registro: 0,nro_sonometro: 0,calibracion: '2020-07-15 00:00:00',fecha: '2020-07-15 00:00:00',hora_ini: '2020-07-15 09:00:00',hora_fin: '2020-07-15 09:30:00',met_estado: 'Despejado',met_temperatura:20.0,met_humedad:70.0,met_viento_velocidad:0.5,met_viento_dir:'S',fotos:'',audios:'',observaciones:'',eventos:'',laeq:0.0,lamx:0.0,lamin:0.0,la10:0.0,la50:0.0,la90:0.0,usuario:'',activo: 1,evento_tipo:'',evento_hora_ini:'',evento_hora_fin:'',evento_descripcion:'',archivosfotos:[], tmp_fotos: [],archivosaudios:[], tmp_audios: []},
		popup_ver_registro: {visible: false, tipo: ''},
		popup_ruido: {visible: false, tipo: ''},
	},
  
  	mutations:{

	},

	actions: {
/*	obtener_datos_json: async function({commit}){
			const data = await fetch('cursos_json');
			const cursos = await data.json();
			commit('llenarcursos', cursos)
		}
*/
	}
})


var app = new Vue({
  el: '#app',
  data: {
		  pagina_visible: 'dl_login',
		  visitCount: 33,
		  hideCompletedTodos: false,
		  todos: [],
		  error: null,
		  time: '13:20',
		  location:null,
		  gettingLocation: false,
		  errorStr:null
		},	
  store:store,
  methods: {
	obtengo_ubicacion: function(){
	if("geolocation" in navigator) {
	    navigator.geolocation.getCurrentPosition(pos => {
			store.state.centro_gps.latitud = pos.coords.latitude;
			store.state.centro_gps.longitud = pos.coords.longitude;
									})
	}
	},	
	obtengo_progresiva: function(latitud,longitud){
	return new Promise( function(resolve, reject){    
		var punto = turf.point([latitud,longitud]);
		var progresiva = 0;
		caches.open('ADAPTA_CACHE-V1').then(cache => {
			cache.match('archivos/geo/Eje_Via_Progresivas20.geojson').then(item => { 
				if (typeof item !== 'undefined'){
			  item.json().then(buffer => {
				  var data = buffer.features;
				  var distancia = 9999999;
				  for(i=0;i<data.length;i++)
				  {
					var latitud2 = data[i].geometry.coordinates[1];
					var longitud2 = data[i].geometry.coordinates[0];

					var par1 = Math.abs(latitud2 - latitud);
					var par2 = Math.abs(longitud2 - longitud);
					var distancia2 = Math.sqrt(Math.pow(par1,2) + Math.pow(par2,2));
					if (distancia2 < distancia){
						distancia = distancia2;
						progresiva = data[i].properties.PROGRESIVA;
					}
				  }
				  resolve(progresiva); 
			  })
			}  
			else
			{
				resolve(0);
			}
			})
	})
})
	},
	obtengo_icono: function(tipo){
		return new Promise(function(resolve, reject){    
			if (tipo == 'Ruido')
			{
				fetch('archivos/iconos/volume-up.png')
				.then(function(response) {
				  return response.blob();
				})
				.then(function(miBlob) {
				  var objectURL = URL.createObjectURL(miBlob);
				  var rutaicono = objectURL;
				  var icono = L.icon({
					iconUrl: rutaicono,                         
					iconSize:     [30, 30], // size of the icon
					iconAnchor:   [15,15], // point of the icon which will correspond to marker's location
					popupAnchor:  [0, 0] // point from which the popup should open relative to the iconAnchor
			    	});
				resolve(icono);
				});
			}else
			{
				resolve('archivos/iconos/volume-up.png');
			}
		})
	},
	crear_marker: async function(mapa,ubicacion,id_ref,id,tipo,punto,progresiva,obrador,cant_insp,foto,tramo,zona_urbana,fecha_ini,frecuencia,tipo_obra){
		this.obtengo_icono(tipo).then (response => {
				var ubic = ubicacion.replace("POINT(", "");
				ubic = ubic.replace(")", "");
				var latlong = ubic.split(" ");
				var centro = L.latLng(latlong[0],latlong[1]);	 
				var marker = L.marker(centro,{
				id_ref: id_ref,
				id: id,
				tipo: tipo,
				punto: punto,
				progresiva: progresiva,
				obrador: obrador,
				cant_insp: cant_insp,
				tramo: tramo,
				zona_urbana: zona_urbana,
				fecha_ini: fecha_ini,
				frecuencia: frecuencia,
				tipo_obra: tipo_obra,
				foto: foto, 
				icon:response}).addTo(mapa).on('click', function(e) {
					store.state.datos_registro.id_ref = this.options.id_ref;     
					store.state.datos_registro.id = this.options.id;           
					store.state.datos_registro.tipo = this.options.tipo;
					store.state.datos_registro.punto = this.options.punto;
					store.state.datos_registro.progresiva = this.options.progresiva;
					store.state.datos_registro.obrador = this.options.obrador;
					store.state.datos_registro.cant_insp = this.options.cant_insp;
					store.state.datos_registro.foto = this.options.foto;
					store.state.datos_registro.tramo = this.options.tramo;					
					store.state.datos_registro.zona_urbana = this.options.zona_urbana;
					store.state.datos_registro.fecha_ini = this.options.fecha_ini;					
					store.state.layout_visible = 'ver_registro';
				})
				store.state.lista_registros.lista.push(marker);
	   return(response);
	}) 
	},
	cargar_registros_a_mapa: function(mapa){
		for(i=0;i<store.state.lista_registros.lista;i++){
			 store.state.lista_registros.lista[i].remove();
		}
		store.state.lista_registros.lista = [];	
	    caches.open('ADAPTA_CACHE-V1').then(cache => {
			cache.match('/sincronizacion/registros.json').then(item => { 
				if (typeof item !== 'undefined'){
			  item.json().then(buffer => {
				  for(i=0;i<buffer.length;i++){
					  if (buffer[i].id !== "FALSO"){
					 app.crear_marker(mapa,buffer[i].ubicacion,buffer[i].id_ref,buffer[i].id,buffer[i].tipo,buffer[i].punto,buffer[i].progresiva,buffer[i].obrador,buffer[i].cant_insp,buffer[i].foto,buffer[i].tramo,buffer[i].zona_urbana,buffer[i].fecha_ini,buffer[i].frecuencia,buffer[i].tipo_obra);
					  }
				  }
			  }) 
			} else
			{
				resolve(item);
			}
			})
		})	  
	},
	obtengo_fecha: function(fecha){
		var fecha2=  fecha.toLocaleString();
		var parte1 = fecha2.split(" ")[0];
		var parte2 = fecha2.split(" ")[1];
		var dia = parte1.split("/")[0];
		var mes = parte1.split("/")[1];
		var ano = parte1.split("/")[2];
		return ano + "-" + mes + "-" + dia + " " + parte2;
	},	
	obtengo_fecha2: function(fecha){
		var fecha2=  fecha.toLocaleString();
		var parte1 = fecha2.split(" ")[0];
		var parte2 = fecha2.split(" ")[1];
		var dia = parte1.split("/")[0];
		var mes = parte1.split("/")[1];
		var ano = parte1.split("/")[2];
		var hora = parte2.split(":")[0];
		var minuto = parte2.split(":")[1];
		var segundo = parte2.split(":")[2];
		return "_" + ano + mes + dia + hora + minuto + segundo;
	},
	bajar_archivo: function(url, filename) {
		let xhr = new XMLHttpRequest();
		xhr.open("GET", url, true);
		xhr.responseType = "blob";
		xhr.onload = function(e) {
		  if (this.status == 200) {
			const blob = this.response;
			const a = document.createElement("a");
			document.body.appendChild(a);
			const blobUrl = window.URL.createObjectURL(blob);
			a.href = blobUrl;
			a.download = filename;
			a.click();
			setTimeout(() => {
			  window.URL.revokeObjectURL(blobUrl);
			  document.body.removeChild(a);
			}, 0);
		  }
		};
		xhr.send();
	},
	valores_defecto_ruido: function(){
	store.state.datos_ruido.id_registro = store.state.datos_registro.id;
	store.state.datos_ruido.id = obtengo_nuevo_id();
	store.state.datos_ruido.id_ref = 0;
	store.state.datos_ruido.nro_sonometro = 0;
	store.state.datos_ruido.calibracion = this.obtengo_fecha(new Date());
	store.state.datos_ruido.fecha = this.obtengo_fecha(new Date());
	store.state.datos_ruido.hora_ini = this.obtengo_fecha(new Date());
	store.state.datos_ruido.hora_fin = this.obtengo_fecha(new Date());
	store.state.datos_ruido.met_temperatura = 0;
	store.state.datos_ruido.met_humedad = 0;
	store.state.datos_ruido.met_viento_velocidad = 0;
	store.state.datos_ruido.met_viento_dir = 'S';
	store.state.datos_ruido.fotos = '';
	store.state.datos_ruido.audios = '';
	store.state.datos_ruido.archivosfotos = [];
	store.state.datos_ruido.archivosaudios = [];
	store.state.datos_ruido.tmp_fotos = [];
	store.state.datos_ruido.tmp_audios = [];
	store.state.datos_ruido.observaciones = '';
	store.state.datos_login.usuario = store.state.datos_login.usuario;
	store.state.datos_ruido.activo = 1;
	store.state.datos_ruido.eventos = '[]';
	store.state.datos_ruido.laeq = 0;
	store.state.datos_ruido.lamx = 0;
	store.state.datos_ruido.lamin = 0;
	store.state.datos_ruido.la10 = 0;
	store.state.datos_ruido.la50 = 0;
	store.state.datos_ruido.la90 = 0;
	store.state.datos_ruido.evento_tipo = 'Externo-Vehiculos';
	store.state.datos_ruido.evento_hora_ini = this.obtengo_fecha(new Date());
	store.state.datos_ruido.evento_hora_fin = this.obtengo_fecha(new Date());
	store.state.datos_ruido.evento_descripcion = '';
	},
	genero_reporte_ruido_tipo1: async function(){
//INICIO REPORTE GENERAL DE RUIDO //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//obtengo datos a reportar
////////////////////////////

let promesa1 = new Promise((resolve, reject) => {
	var registros = [];
		caches.open('ADAPTA_CACHE-V1').then(cache => {
			cache.match('/sincronizacion/registros.json').then(item => { 
				if (typeof item !== 'undefined'){
			  item.json().then(buffer => {
				  for(i=0;i<buffer.length;i++){
					  if (buffer[i].id !== "FALSO"){
						  var registro = [buffer[i].id,buffer[i].tipo,buffer[i].punto,buffer[i].progresiva,buffer[i].obrador,buffer[i].tramo,buffer[i].zona_urbana,buffer[i].fecha_ini,buffer[i].frecuencia,buffer[i].tipo_obra,buffer[i].ubicacion,buffer[i].activo];
						   registros.push(registro);
					  }
					  if (i == buffer.length  - 1)
					  {resolve(registros);}
				  }
			  }) 
			} 
			})
		})
	})		
let promesa2 = new Promise((resolve, reject) => {			 
		var inspecciones = [];
 		caches.open('ADAPTA_CACHE-V1').then(cache => {
			cache.match('/sincronizacion/ruido_inspecciones.json').then(item => { 
				if (typeof item !== 'undefined'){
			  item.json().then(buffer => {
				  for(i=0;i<buffer.length;i++){
					  if (buffer[i].id !== "FALSO"){
						  var inspeccion = [buffer[i].id_registro,buffer[i].fecha,buffer[i].laeq,buffer[i].lamin,buffer[i].lamx,buffer[i].la10,buffer[i].la50,buffer[i].la90,buffer[i].observaciones,buffer[i].activo,buffer[i].id];
					 	  inspecciones.push(inspeccion);
					  }
					  if (i == buffer.length  - 1)
					  {resolve(inspecciones);}
				  }
			  }) 
			} 
			})
		}) 
	})
let promesa3 = new Promise((resolve, reject) => {
		var standards = [];
		caches.open('ADAPTA_CACHE-V1').then(cache => {
			cache.match('/sincronizacion/ruido_standard.json').then(item => { 
				if (typeof item !== 'undefined'){
			  item.json().then(buffer => {
				  for(i=0;i<buffer.length;i++){
					  if (buffer[i].id !== "FALSO"){
						  var standard = [buffer[i].id_registro,buffer[i].ifc,buffer[i].ifclb3,buffer[i].mvotma,buffer[i].lbx];
					 	  standards.push(standard);
					  }
					  if (i == buffer.length  - 1)
					  {resolve(standards);}
				  }
			  }) 
			} 
			})
		}) 

})

var registros = await promesa1;

var inspecciones = await promesa2;

var standards = await promesa3;


	var nombre_reporte= "Reporte_General_Ruido_" + this.obtengo_fecha2(new Date()) + ".xlsx";
	var excel = $JExcel.new("Lato 11 #666666");			// Default font
			
	// excel.set is the main function to generate content:
	// 		We can use parameter notation excel.set(sheetValue,columnValue,rowValue,cellValue,styleValue) 
	// 		Or object notation excel.set({sheet:sheetValue,column:columnValue,row:rowValue,value:cellValue,style:styleValue })
	// 		null or 0 are used as default values for undefined entries		
	excel.set( {sheet:0,value:"Reporte_General_Ruido" } );

	
	excel.set({row:0,value: 30});
	excel.set({row:1,value: 25});

	excel.set({column:0,value: 10});
	excel.set(0,0,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,0,1,"Tramo",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:1,value: 20});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,1,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,1,1,"Obrador",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:2,value: 10});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,2,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,2,1,"PK",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:3,value: 10});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,3,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,3,1,"Frecuencia",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:4,value: 15});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,4,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,4,1,"Punto",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:5,value: 10});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,5,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,5,1,"Latitud",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:6,value: 10});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,6,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,6,1,"Longitud",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:7,value: 15});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,7,0,"",excel.addStyle({align:"C C",border:"none,none,none,none #333333",fill: "#333333"}));
	excel.set(0,7,1,"Zona Urbana",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:8,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,8,0,"",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,8,1,"IFC",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:9,value: 10});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,9,0,"Estándares Diurnos",excel.addStyle({align:"L C",fill: "#CCCCCC",border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,9,1,"IFCLB+3",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:10,value: 15});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,10,0,"",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,10,1,"GUIA MVOTMA",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:11,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,11,0,"",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"none,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,11,1,"LB+X",excel.addStyle({align:"C C",fill: "#CCCCCC",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));

	excel.set({column:12,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,12,0,"",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,12,1,"LAeq",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:13,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,13,0,"",excel.addStyle({align:"L C",fill: "#F8C296",border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,13,1,"LAmx",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:14,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,14,0,"Línea de base",excel.addStyle({align:"C C",fill: "#F8C296",border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,14,1,"LAmin",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:15,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,15,0,"",excel.addStyle({align:"C C",fill: "#F8C296",border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,15,1,"LA10",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:16,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,16,0,"",excel.addStyle({align:"C C",fill: "#F8C296",border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,16,1,"LA50",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:17,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,17,0,"",excel.addStyle({align:"C C",fill: "#F8C296",border:"none,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,17,1,"LA90",excel.addStyle({align:"C C",fill: "#F8C296",border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));

var meses = ['Mayo 2020', 'Junio 2020', 'Julio 2020', 'Agosto 2020', 'Setiembre 2020', 'Octubre 2020', 'Noviembre 2020', 'Diciembre 2020', 'Enero 2021', 'Febrero 2021', 'Marzo 2021',
'Abril 2021','Mayo 2021', 'Junio 2021', 'Julio 2021', 'Agosto 2021', 'Setiembre 2021', 'Octubre 2021', 'Noviembre 2021', 'Diciembre 2021', 'Enero 2022', 'Febrero 2022', 'Marzo 2022',
'Abril 2022','Mayo 2022', 'Junio 2022', 'Julio 2022', 'Agosto 2022', 'Setiembre 2022', 'Octubre 2022', 'Noviembre 2022', 'Diciembre 2022', 'Enero 2023', 'Febrero 2023', 'Marzo 2023'];

var columna = 18;
var color1 = "#FCE6D5"
var color2 = "#DCECAA"
var color_fondo = color1;
for (i=0;i<meses.length;i++)
{
	excel.set({column:columna,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna,0,"",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna,1,"LAeq",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set({column:columna + 1,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna + 1,0,"",excel.addStyle({align:"L C",fill: color_fondo,border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna + 1,1,"LAmx",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:columna + 2,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna + 2,0,"",excel.addStyle({align:"C C",fill: color_fondo,border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna + 2,1,"LAmin",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:columna + 3,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna + 3,0,meses[i],excel.addStyle({align:"C C",fill: color_fondo,border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna + 3,1,"LA10",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:columna + 4,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna + 4,0,"",excel.addStyle({align:"C C",fill: color_fondo,border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna + 4,1,"LA50",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:columna + 5,value: 7});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna + 5,0,"",excel.addStyle({align:"C C",fill: color_fondo,border:"none,none,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna + 5,1,"LA90",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set({column:columna + 6,value: 15});										// Align cell 3-3  to RIGHT-BOTTOM
	excel.set(0,columna + 6,0,"",excel.addStyle({align:"C C",fill: color_fondo,border:"none,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
	excel.set(0,columna + 6,1,"Observaciones",excel.addStyle({align:"C C",fill: color_fondo,border:"medium,medium,medium,medium #666666",font: "Lato 12 #666666 B"}));
columna = columna + 7;
if (color_fondo == color1){color_fondo = color2}else{color_fondo = color1}
}


fila = 2;
for (i=0;i<registros.length;i++)
{
	var activo = registros[i][11];
	if (activo == 1)
	{
	var registro = registros[i];
	var id_registro = registro[0];
	var latlong = registro[10].replace('POINT(', '').replace(')','').split(' ');
	excel.set({row:fila,value: 15});
	excel.set(0,0,fila,registro[5],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,1,fila,registro[4],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,2,fila,registro[3],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,3,fila,registro[8],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,4,fila,registro[2],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,5,fila,latlong[0],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,6,fila,latlong[1],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	excel.set(0,7,fila,registro[6],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));

	for (j=0;j<standards.length;j++)
	{ 
		var standard = standards[j];
			if (id_registro === standard[0]){
				excel.set(0,8,fila,standard[1],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,9,fila,standard[2],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,10,fila,standard[3],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,11,fila,standard[4],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
			}
	}


	var lista_inspecciones_registro = [];
	for (k=0;k<inspecciones.length;k++)
	{ 			
		var inspeccion = inspecciones[k];
			if (id_registro == inspeccion[0] && inspeccion[9] == 1){
				lista_inspecciones_registro.push(inspeccion);
			}
	}
	if (lista_inspecciones_registro.length > 0){
		var menor_inspeccion = [];
		var menor_fecha = new Date ("2050-12-31 00:00:00");
		for (k=0;k<lista_inspecciones_registro.length;k++)
		{ var fecha = new Date(lista_inspecciones_registro[k][1]);
			if (fecha < menor_fecha){
				menor_fecha = fecha;
				menor_inspeccion = lista_inspecciones_registro[k];
			}
		}	
		excel.set(0,12,fila,menor_inspeccion[2],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
		excel.set(0,13,fila,menor_inspeccion[4],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
		excel.set(0,14,fila,menor_inspeccion[3],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
		excel.set(0,15,fila,menor_inspeccion[5],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
		excel.set(0,16,fila,menor_inspeccion[6],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
		excel.set(0,17,fila,menor_inspeccion[7],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
	}

	if (lista_inspecciones_registro.length > 1){
		for (k=0;k<lista_inspecciones_registro.length;k++)
		{ 
			if(lista_inspecciones_registro[k][10] != menor_inspeccion[10])
			{			
			var fecha = new Date(lista_inspecciones_registro[k][1]);
			var fecha_base = new Date('2020-04-01 00:00:00');
			var posicion_fecha = (((12 * (fecha.getFullYear() - 2020) + fecha.getMonth()) - 5) * 7 ) + 25;
			var inspeccion = lista_inspecciones_registro[k];
			if (fecha >	fecha_base && inspeccion[9] == 1){
				excel.set(0,posicion_fecha,fila,inspeccion[2],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,posicion_fecha + 1,fila,inspeccion[4],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,posicion_fecha + 2,fila,inspeccion[3],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,posicion_fecha + 3,fila,inspeccion[5],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,posicion_fecha + 4,fila,inspeccion[6],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,posicion_fecha + 5,fila,inspeccion[7],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
				excel.set(0,posicion_fecha + 6,fila,inspeccion[8],excel.addStyle({align:"C C",border:"thin,thin,thin,thin #666666",font: "Lato 10 #666666"}));
			}
		}
		}	
	}
	}
fila++;
}
	excel.generate(nombre_reporte);
//FIN REPORTE GENERAL DE RUIDO //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//FINALIZO REPORTE DE RUIDO TIPO 1
},
genero_kml_ruido_tipo1: async function(){
	//INICIO kmz GENERAL DE RUIDO //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//obtengo datos a reportar
	////////////////////////////
	
	let promesa1 = new Promise((resolve, reject) => {
		var registros = [];
			caches.open('ADAPTA_CACHE-V1').then(cache => {
				cache.match('/sincronizacion/registros.json').then(item => { 
					if (typeof item !== 'undefined'){
				  item.json().then(buffer => {
					  for(i=0;i<buffer.length;i++){
						  if (buffer[i].id !== "FALSO"){
							  var registro = [buffer[i].id,buffer[i].tipo,buffer[i].punto,buffer[i].progresiva,buffer[i].obrador,buffer[i].tramo,buffer[i].zona_urbana,buffer[i].fecha_ini,buffer[i].frecuencia,buffer[i].tipo_obra,buffer[i].ubicacion,buffer[i].activo];
							   registros.push(registro);
						  }
						  if (i == buffer.length  - 1)
						  {resolve(registros);}
					  }
				  }) 
				} 
				})
			})
		})		

	var registros = await promesa1;


var kml = '<?xml version="1.0" encoding="UTF-8"?>';
kml = kml + '<kml xmlns="http://www.opengis.net/kml/2.2" xmlns:gx="http://www.google.com/kml/ext/2.2" xmlns:kml="http://www.opengis.net/kml/2.2" xmlns:atom="http://www.w3.org/2005/Atom">';
kml = kml + '<Document><name>Ruido.kml</name><Style id="sh_grn-circle"><IconStyle><scale>1.3</scale><Icon>';
kml = kml + '<href>http://maps.google.com/mapfiles/kml/paddle/grn-circle.png</href></Icon><hotSpot x="32" y="1" xunits="pixels" yunits="pixels"/>';
kml = kml + '</IconStyle><BalloonStyle></BalloonStyle><ListStyle><ItemIcon><href>http://maps.google.com/mapfiles/kml/paddle/grn-circle-lv.png</href>';
kml = kml + '</ItemIcon></ListStyle></Style><Style id="sn_grn-circle"><IconStyle><scale>1.1</scale><Icon><href>http://maps.google.com/mapfiles/kml/paddle/grn-circle.png</href>';
kml = kml + '</Icon><hotSpot x="32" y="1" xunits="pixels" yunits="pixels"/></IconStyle><BalloonStyle></BalloonStyle><ListStyle>';
kml = kml + '<ItemIcon><href>http://maps.google.com/mapfiles/kml/paddle/grn-circle-lv.png</href></ItemIcon></ListStyle></Style>';
kml = kml + '<Style id="sn_grn-blank"><IconStyle><scale>1.1</scale><Icon><href>http://maps.google.com/mapfiles/kml/paddle/grn-blank.png</href>';
kml = kml + '</Icon><hotSpot x="32" y="1" xunits="pixels" yunits="pixels"/></IconStyle><BalloonStyle></BalloonStyle><ListStyle><ItemIcon>';
kml = kml + '<href>http://maps.google.com/mapfiles/kml/paddle/grn-blank-lv.png</href></ItemIcon></ListStyle></Style><Style id="sh_grn-blank">';
kml = kml + '<IconStyle><scale>1.3</scale><Icon><href>http://maps.google.com/mapfiles/kml/paddle/grn-blank.png</href></Icon>';
kml = kml + '<hotSpot x="32" y="1" xunits="pixels" yunits="pixels"/></IconStyle><BalloonStyle></BalloonStyle><ListStyle><ItemIcon>';
kml = kml + '<href>http://maps.google.com/mapfiles/kml/paddle/grn-blank-lv.png</href></ItemIcon></ListStyle></Style><StyleMap id="msn_grn-blank">';
kml = kml + '<Pair><key>normal</key><styleUrl>#sn_grn-blank</styleUrl></Pair><Pair><key>highlight</key><styleUrl>#sh_grn-blank</styleUrl>';
kml = kml + '</Pair></StyleMap><StyleMap id="msn_grn-circle"><Pair><key>normal</key><styleUrl>#sn_grn-circle</styleUrl></Pair><Pair>';
kml = kml + '<key>highlight</key><styleUrl>#sh_grn-circle</styleUrl></Pair></StyleMap><Folder>';
kml = kml + '<name>Ruido_sitios_mediciones</name><open>1</open>';


	for (i=0;i<registros.length;i++){
		var registro = registros[i];
		var latlong = registro[10].replace('POINT(', '').replace(')','').split(' ');
		kml = kml + '<Placemark><name>' + registro[2] + '</name><LookAt>';
		kml = kml + '<longitude>' + latlong[1] + '</longitude>';
		kml = kml + '<latitude>' + latlong[0] + '</latitude>';
		kml = kml + '<altitude>0</altitude>';
		kml = kml + '<range>1237.205460638887</range><gx:altitudeMode>relativeToSeaFloor</gx:altitudeMode></LookAt>';
		kml = kml + '<styleUrl>#msn_grn-blank</styleUrl>';
		kml = kml + '<description><![CDATA[<table border=\"0\"> <tr><td> <h2 width=\"620\" style=\"color:darkbrown;text-align:center\">';
		kml = kml + 'Datos de registro: ' + registro[2] + '</table><table border=\"0\">';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Tipo: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[1] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Punto: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[2] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Progresiva: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[3] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Obrador: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[4] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Tramo: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[5] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Zona urbana 1=Si 0=No: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[6] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Fecha: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[7] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Frecuencia: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[8] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Tipo obra: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + registro[9] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Latitud: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + latlong[0]  + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + 'Longitud: </th><td width=\"450\" style=\"background-color:khaki;text-align:right\">' + latlong[1] + '</td></tr>';
		kml = kml + '<tr><th width=\"220\" style=\"background-color:darkgrey;text-align:left\">';
		kml = kml + '</table><p><font color=\"darkblue\">Adapta-UPM</font></p> ]]></description>';		
		kml = kml + '<Point><gx:drawOrder>1</gx:drawOrder>';
		kml = kml + '<coordinates>' + latlong[1] + ',' + latlong[0] + '</coordinates></Point></Placemark>';
	}
	kml = kml + '</Folder></Document></kml>';


	  var data = new Blob([kml], {type: 'text/plain'});
	  textFile = window.URL.createObjectURL(data);
	  this.bajar_archivo(textFile, "prueba.kml");

	}


}  
})

	

if ('serviceWorker' in navigator) {
	window.addEventListener('load', function() {
	  navigator.serviceWorker.register('sw.js').then(function(registration) {
		// Registration was successful
		console.log('ServiceWorker se registro correctamente: ', registration.scope);
	  }, function(err) {
		// registration failed :(
		console.log('ServiceWorker fallo al registrarse: ', err);
	  });
	});
  }

var hayconexion = true;
var control_cambio_conexion = true;
window.addEventListener('offline', () => {hayconexion = false; store.state.hayconexion = false});
window.addEventListener('online', () => { 
	console.log("se retoma conexion");
	hayconexion = true;
	store.state.hayconexion = true;
	sincronizar_cache();
});
if (navigator.onLine)
{
sincronizar_cache();
}

var forzar_carga_registros = false;

function obtengo_nuevo_id(){
	var date = new Date();
	var p1 = String(date.getYear());
	if (date.getMonth() < 10)
	{
		var p2 = "0" + String(date.getMonth());
	}else
	{
		var p2 = String(date.getMonth());
	}
	if (date.getDate() < 10)
	{
		var p3 = "0" + String(date.getDate());
	}else
	{
		var p3 = String(date.getDate());
	}
	if (date.getHours() < 10)
	{
		var p4 = "0" + String(date.getHours());
	}else
	{
		var p4 = String(date.getHours());
	}
	if (date.getMinutes() < 10)
	{
		var p5 = "0" + String(date.getMinutes());
	}else
	{
		var p5 = String(date.getMinutes());
	}
	var id_registro = p1 + p2 + p3 + p4 + p5 + String(parseInt(0 + (Math.random() * 500)));
	return id_registro;
}
