Vue.component('nuevo_registro',{
    data: function () {
        return {
          id_ref: store.state.datos_registro.id_ref,
          id: store.state.datos_registro.id,
          tipo: store.state.datos_registro.tipo,
          tipo_obra: store.state.datos_registro.tipo_obra,
          punto: store.state.datos_registro.punto,
          progresiva: store.state.datos_registro.progresiva,
          obrador: store.state.datos_registro.obrador,
          foto: store.state.datos_registro.foto,
          tmp_foto: store.state.datos_registro.tmp_foto,
          frecuencia: store.state.datos_registro.frecuencia,
          fecha_ini: store.state.datos_registro.fecha_ini,
          tramo: store.state.datos_registro.tramo,
          zona_urbana: store.state.datos_registro.zona_urbana,
          isImageModalActive: false,
          hayconexion: store.state.hayconexion,
        }
    },
    template: /*html*/`
   <div>
   <div class="box is-mobile has-background-light p-1 m-1">

                    <p class="title is-4 text-white bg-success p-2 m-2"  style="width:100%">Ingresar nuevo registro</p>
              
                    <div class="columns m-1">
                      <div class="column is-full-mobile p-1 m-1">
                        <p class="level-item subtitle is-6"><strong>Tipo:</strong> {{tipo}}</p>
                      </div>
                      <div class="column is-full-mobile p-1 m-1">
                        <p class="level-item subtitle is-6"><strong>Progresiva:</strong> {{progresiva}}</p>
                      </div>                      
                      <div class="column is-full-mobile p-1 m-1">
                      <p class="level-item subtitle is-6"><strong>Tramo:</strong> {{tramo}}</p>
                      </div>  
                    </div>

                    <div class="columns m-1">
                      <div class="field column is-full-mobile p-1 m-1">
                      <b-switch true-value="Si" false-value="No" v-model="zona_urbana" type="is-success">
                      {{zona_urbana == 'Si' ? $store.state.datos_registro.zona_urbana = "Si" : $store.state.datos_registro.zona_urbana = "No"}}
                       zona poblada 
                      </b-switch>
                      </div>

                      <b-field class="field column is-full-mobile p-1 m-1" label="Fecha de inicio">
                      <b-datepicker v-model="fecha_inicial"
                          placeholder="Seleccionar fecha..."
                          icon="calendar-today"
                          trap-focus>
                      </b-datepicker>
                      </b-field>

                      <div class="column is-full-mobile p-1 m-1">
                          <b-field label="Frecuencia">
                          <b-select  @change.native="cambio_frecuencia($event)" v-model="frecuencia" placeholder="Seleccionar frecuencia">
                          <option value = "Semanal">Semanal</option>
                          <option value = "Mensual">Mensual</option>
                          <option value = "Trimestral">Trimestral</option>
                          <option value = "Semestral">Semestral</option>
                          <option value = "Otros">Otros</option>
                          </b-select>
                          </b-field>
                      </div>  
                      <div class="column is-full-mobile p-1 m-1">
                          <b-field label="Tipo de Obra">
                          <b-select  @change.native="cambio_tipo_obra($event)" v-model="tipo_obra" placeholder="Seleccionar tipo obra">
                          <option value = "Obrador">Obrador</option>
                          <option value = "Deposito">Deposito</option>
                          <option value = "Planta de soldadura">Planta de soldadura</option>
                          <option value = "Acopios">Acopios</option>
                          <option value = "Planta de trituracion">Planta de trituracion</option>
                          <option value = "Taller">Taller</option>
                          <option value = "Otros">Otros</option>
                          </b-select>
                          </b-field>
                      </div> 
                    </div> 
                    <b-field label="Punto:" type="is-success">
                       <b-input placeholder="Punto:" @input.native="actualizo_punto"></b-input>
                    </b-field>
                    <b-field label="Obrador:" type="is-success">
                        <b-input placeholder="Obrador:" @input.native="actualizo_obrador"></b-input>
                    </b-field>

        <footer >
                    <form enctype="multipart/form-data">
                    <input accept="image/*" @change="guardo_fotografia" capture="camera" id="foto_registro" name="foto_registro" ref="foto_registro" style="display:none" type="file"> 
                    </form>                   
                <div class="columns is-gapless is-multiline is-mobile m-1 p-1">
                    <div class="column is-full-mobile  m-1 p-1">
                    <b-button  @click="$refs.foto_registro.click()" type="is-success" rounded  expanded  icon-left="camera-plus">
                    Tomar Foto
                    </b-button>
                    </div>
                    <div class="column is-full-mobile  m-1 p-1">
                    <b-button  @click="guardar_nuevo_registro()" type="is-success" rounded  expanded  icon-left="cloud-upload">
                    Guardar
                    </b-button>
                    </div>

                    <div class="column is-full-mobile  m-1 p-1">
                    <b-button  @click="volver()" type="is-success" rounded  expanded  icon-left="arrow-left-circle">
                    Volver
                    </b-button>
                    </div>

                </div>
                </footer>
          </div>
 
 </div>  		
    `,
    computed:{
      fecha_inicial:{
        get:  function () {
        return new Date(store.state.datos_registro.fecha_ini)
         },
        set:  function (valor) {
          store.state.datos_registro.fecha_ini = valor.toISOString().slice(0, 19).replace('T', ' ');
          },
        }
    },
    methods:{
      volver(){
        store.state.layout_visible = 'layout_relevamientos';
      },
      cambio_frecuencia(e){
        store.state.datos_registro.frecuencia = e.target.value;
      },
      cambio_fecha(){
 
        alert( store.state.datos_registro.fecha_ini );
      },
      cambio_tipo_obra(e){
        store.state.datos_registro.tipo_obra = e.target.value;
      },      
      actualizo_punto(e){//_______________________________________________________________________________________________
        store.state.datos_registro.punto = e.target.value;
      },
      actualizo_obrador(e){//_______________________________________________________________________________________________
        store.state.datos_registro.obrador = e.target.value;
      },  
      guardo_fotografia(e){//_______________________________________________________________________________________________
        var d = new Date();
            var dirupload;
            var ano = d.getFullYear();
            var mes = d.getMonth() + 1;
            if (mes < 10){
              mes = "0" + mes;
            }
            var dia = d.getDate();
            if (dia < 10){
              dia = "0" + dia;
            }
            var horas = d.getHours();
            var minutos = d.getMinutes();
            var segundos = d.getSeconds();
            nom_archivo_foto = "REGISTRO" + "-" + ano + mes + dia + "-" + horas + "-" + minutos + "-" + segundos;
            let last_dot = e.target.files[0].name.lastIndexOf('.')
            let ext = e.target.files[0].name.slice(last_dot + 1)
        nom_archivo_foto = nom_archivo_foto + "." + ext;
        var valfoto = e.target.files[0];      
        var canvasBlob = foto_a_800(valfoto);
        canvasBlob.then(function(blob) {
          store.state.datos_registro.archivofoto = blob;
          store.state.datos_registro.tmp_foto = URL.createObjectURL(blob);
        });
      store.state.datos_registro.foto = "/ADAPTA/archivos/fotos/" + nom_archivo_foto;    
      },  


      
      guardar_nuevo_registro(){  //_____________________________________________________________________________________________
    //Genero sentencia sql completa/////////////////////////////////////////////////////////////////////////////////////////  
        var fecha = app.obtengo_fecha(new Date());
        var usuario = store.state.datos_login.usuario;
        var sql = "";
        store.state.datos_ruido_standard.id_registro = store.state.datos_registro.id;
        var ubicacion_registro = "GeomFromText('" + store.state.datos_registro.ubicacion + "',4326)";	
        var sql1 = "INSERT INTO registros(ID,TIPO,PUNTO,PROGRESIVA,OBRADOR,UBICACION,CANT_INSP,ACTIVO,FOTO,FECHA,USUARIO,FRECUENCIA,TIPO_OBRA,TRAMO,ZONA_URBANA,FECHA_INI)VALUES(";
        var sql2 = store.state.datos_registro.id  + ",'" + store.state.datos_registro.tipo  + "','" + store.state.datos_registro.punto + "',";
        var sql3 = store.state.datos_registro.progresiva  + ",'" + store.state.datos_registro.obrador + "',";
        var sql4 = ubicacion_registro + ",0,1,'" + store.state.datos_registro.foto + "','"; 
        var sql5 = fecha + "','" + usuario + "','" + store.state.datos_registro.frecuencia + "','" + store.state.datos_registro.tipo_obra + "',";
        var sql6 = store.state.datos_registro.tramo + ",'" +  store.state.datos_registro.zona_urbana  + "','" + store.state.datos_registro.fecha_ini + "')";
            sql = sql1 + sql2 + sql3 + sql4 + sql5 + sql6;

        var sql1 = "INSERT INTO ruido_standard(ID_REGISTRO,IFC,IFCLB3,MVOTMA,LBX)VALUES(";
        var sql2 = store.state.datos_registro.id  + ",'','','','')";
            sql_standard = sql1 + sql2;

        var registro_nuevo_standard = {
          "id_registro": store.state.datos_registro.id,
          "ifc": '',
          "ifclb3": '',
          "mvotma":  '',
          "lbx": ''
          };

           // console.log(sql);
        var nuevo_id = store.state.datos_registro.id;   
        var centro_mapa = "POINT(" + map.getCenter().lat + " " + map.getCenter().lng + ")";
        if (hayconexion == true) { // si hay conexion........................................................................
          //consulto base de datos
          var fd = new FormData();
          fd.append("sql",sql);
          fd.append("sql_standard",sql_standard);
          fd.append("foto",store.state.datos_registro.foto);
          fd.append("archivofoto",store.state.datos_registro.archivofoto);
							var getUrl = window.location;
							var baseUrl = getUrl .protocol + "//" + getUrl.host + "/" + getUrl.pathname.split('/')[1];
							var phpfile = baseUrl + '/php/registros_agregar.php';
							var xhr = new XMLHttpRequest();	
							xhr.open('POST',phpfile,true);
							xhr.onload = function() {
              //  console.log(this.response);
              var data = JSON.parse(this.response);
              caches.open('ADAPTA_CACHE-V1').then(cache => {
                cache.match('/sincronizacion/ruido_standard.json').then(item => {
                  item.json().then(buffer => {
                    var data2 = [];
                    for(i=0;i<buffer.length;i++){
                      data2.push(buffer[i]);
                    }
                    data2.push(registro_nuevo_standard);
                    cache.put('/sincronizacion/ruido_standard.json', new Response(JSON.stringify(data2)));
                  });
                 });
              })
								caches.open('ADAPTA_CACHE-V1').then(cache => {
                  cache.match('/sincronizacion/registros.json').then(item => {
                  cache.put('/sincronizacion/registros.json', new Response(JSON.stringify(data)));
                  app.crear_marker(map,centro_mapa,store.state.datos_registro.id_ref,nuevo_id,store.state.datos_registro.tipo,store.state.datos_registro.punto,store.state.datos_registro.progresiva,store.state.datos_registro.obrador,store.state.datos_registro.cant_insp,store.state.datos_registro.foto,store.state.datos_registro.tramo,store.state.datos_registro.zona_urbana,store.state.datos_registro.fecha_ini,store.state.datos_registro.frecuencia,store.state.datos_registro.tipo_obra);
                  store.state.layout_visible = 'layout_relevamientos';
                  });
								});
							};
							xhr.send(fd);
						}//fin si hay conexion........................................................................
						else		
						{
                  caches.open('ADAPTA_CACHE-V1').then(cache => {
                    if (store.state.datos_registro.foto != ''){
                    var nombre_cache = store.state.datos_registro.foto;
                    return cache.put(nombre_cache, new Response(store.state.datos_registro.archivofoto));
                    }
                  })
                  var foto =  store.state.datos_registro.foto;
                  var unionsqls = sql + ";" + sql_standard;
                  agrego_registros_a_sincronizar(unionsqls,foto);


/////////////////////////////////////////////////////////////////////////////////////////////
var registro_nuevo = {
"id": store.state.datos_registro.id,
"id_ref": 0,
"tipo": store.state.datos_registro.tipo,
"punto": store.state.datos_registro.punto,
"progresiva": store.state.datos_registro.progresiva,
"obrador": store.state.datos_registro.obrador,
"ubicacion": store.state.datos_registro.ubicacion,
"cant_insp": store.state.datos_registro.cant_insp,
"activo": store.state.datos_registro.activo,
"foto": store.state.datos_registro.foto,
"tramo": store.state.datos_registro.tramo,
"zona_urbana": store.state.datos_registro.zona_urbana,
"fecha_ini": store.state.datos_registro.fecha_ini,
"frecuencia": store.state.datos_registro.frecuencia,
"tipo_obra": store.state.datos_registro.tipo_obra
};
var registro_nuevo_standard = {
  "id_registro": store.state.datos_registro.id,
  "ifc": '',
  "ifclb3": '',
  "mvotma":  '',
  "lbx": ''
  };
caches.open('ADAPTA_CACHE-V1').then(cache => {
  cache.match('/sincronizacion/registros.json').then(item => { 
    item.json().then(buffer => {
        var data = [];
        for(i=0;i<buffer.length;i++){
          data.push(buffer[i]);
        }
        data.push(registro_nuevo);
        cache.put('/sincronizacion/registros.json', new Response(JSON.stringify(data)));
        app.crear_marker(map,centro_mapa,0,store.state.datos_registro.id,store.state.datos_registro.tipo,store.state.datos_registro.punto,store.state.datos_registro.progresiva,store.state.datos_registro.obrador,store.state.datos_registro.cant_insp,store.state.datos_registro.foto,store.state.datos_registro.tramo,store.state.datos_registro.zona_urbana,store.state.datos_registro.fecha_ini,store.state.datos_registro.frecuencia,store.state.datos_registro.tipo_obra);
        store.state.layout_visible = 'layout_relevamientos'; 
      })
    }) 
    .catch(function() {
         console.log("encontro el cache de registros vacio");
         cache.put('/sincronizacion/registros.json', new Response(JSON.stringify(registro)));
         app.crear_marker(map,centro_mapa,0,store.state.datos_registro.id,store.state.datos_registro.tipo,store.state.datos_registro.punto,store.state.datos_registro.progresiva,store.state.datos_registro.obrador,store.state.datos_registro.cant_insp,store.state.datos_registro.foto,store.state.datos_registro.tramo,store.state.datos_registro.zona_urbana,store.state.datos_registro.fecha_ini,store.state.datos_registro.frecuencia,store.state.datos_registro.tipo_obra);
      })
    });  
    caches.open('ADAPTA_CACHE-V1').then(cache => {
      cache.match('/sincronizacion/ruido_standard.json').then(item => { 
        item.json().then(buffer => {
            var data = [];
            for(i=0;i<buffer.length;i++){
              data.push(buffer[i]);
            }
            data.push(registro_nuevo_standard);
            cache.put('/sincronizacion/ruido_standard.json', new Response(JSON.stringify(data)));
          })
        }) 
        .catch(function() {
             console.log("encontro el cache de ruido_standard.json vacio");
             cache.put('/sincronizacion/ruido_standard.json', new Response(JSON.stringify(registro_nuevo_standard)));
         })
        });  

    forzar_carga_registros == true;  
    }
    
    }
    }
            
 })